' -----------------------------------------------------------------------------
'                     S C R I P T   S P E C I F I C A T I O N
'                     Copyright 2014-2015 Motorola Solutions, Inc.
'                              All Rights Reserved.
'                    Motorola Solutions Confidential Restricted
' -----------------------------------------------------------------------------
'
' NAME
'       Terminate.vbs
'
' DESCRIPTION
'       Terminate implementation for Motorola OpenJDK
'
' MODIFICATION HISTORY
' Date       Change
' -----------------------------------------------------------------------------
' 16 Dec 14  Initial creation
' 18 Dec 14  Terminating java.exe and javaw.exe
' 18 Feb 15  B-179526    A716 Motorola OpenJDK terminate script kills all java*.exe processes
' -----------------------------------------------------------------------------
'

Option Explicit

Function Terminate (ByVal appName, ByVal logFileName)
    Dim strMessage, stopConfigResult

    On Error Resume Next

    ' Default returned value is FAIL
    Terminate = FAIL

    ' Stop Motorola Java processes, if any is running
    stopConfigResult = StopMotorolaOpenJDKByPath()

    ' Check for errors
    strMessage = "Could not stop java. Application name: " & appName & ". Error number is " & Err.Number & ": " & Err.Description
    If(CheckForErrors(strMessage) = True) Then
        Exit Function
    End If

    ' Log result of stopping Config.exe
    if (stopConfigResult = SUCCESS) Then
        strMessage = "Java was stopped successfully. Application name: " & appName

        Call WriteToLogFile(strMessage, INFO_C)
        If (Err.Number <> 0) Then
            Err.Clear
            Exit Function
        End If
    Else
        strMessage = "Attempt to stop java failed. Application name: " & appName

        Call WriteToLogFile(strMessage, ERROR_C)

        Err.Clear

        Exit Function
    End If

    Terminate = SUCCESS
End Function
